// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't


//        reale zeit:  fixed step:  inner check:  big future  2nd rotation (seed 1/0)
//Still:  110000       105880       113800        114510      117120/112350
//Move:   109000       104140       115330        ?           ?     /111800

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <vector>

#if defined(_WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"

HWND hwnd;
HBITMAP hBitmap;
HDC hdcMem;
const int xFont=9, yFont=16;
const int xChars = 0x100*2;
const int yChars = 50;
GameRam GameRam::last_ram;

GameRam gameram;
bool updating = false;
int RunningTime = 0;
DirInfo BestDirInfo[2];
bool ErrorsOccured = false;

class ObjectsState
{
public:
	ObjectsState(int StartTime, int DestroyedObject, const GameRam& ram)
	{
		this->StartTime = StartTime;
		this->DestroyedObject = DestroyedObject;
		ValidUntilTime = 1000000;
		CollisionCauser = -1;
		memcpy(Objects, ram.GetObjects(), sizeof(Objects));
		for(int i = 0; i < NumObjects; i++)
		{
//			Objects[i].Status = ram.VarO(RAMO_Status, i);
			assert(i != DestroyedObject || Objects[i].Status <= 0);
/*			Objects[i].PositionX = MakeWord(ram.VarO(RAMO_PositionX, i), ram.VarO(RAMO_PositionExactX, i));
			Objects[i].PositionY = MakeWord(ram.VarO(RAMO_PositionY, i), ram.VarO(RAMO_PositionExactY, i));
			Objects[i].VelocityX = ram.VarO(RAMO_VelocityX, i);
			Objects[i].VelocityY = ram.VarO(RAMO_VelocityY, i);*/
		}
	}
	int StartTime, ValidUntilTime;
	int CollisionCauser;
	int DestroyedObject;
	Object Objects[NumObjects];
};

const int FutureTimeSteps = 43;
//int FutureTimeSteps = 2;
std::vector<ObjectsState>* pObjectsStates = 0;
int CurrentTime = -1;
__int64* pScore = 0;

KeysPacket GameRam::CalcDirInfos(ShotInfo* pShotInfo, int* pDeltaDir, bool CalcSecondShoot)
{
	GameRam OriginalRam = *this;
	*pShotInfo = ShotInfo();

	std::vector<ObjectsState> ObjectsStates;
	ObjectsStates.push_back(ObjectsState(0, -1, *this));
	assert(pObjectsStates == 0);
	pObjectsStates = &ObjectsStates;
	for(int t = 0; t < FutureTimeSteps+ShotLifetime; t++)
	{
		CurrentTime = t;
		Move(KeysPacket(), ShotInfo());
	}
	CurrentTime = -1;
	pObjectsStates = 0;

	*this = OriginalRam;

	int MinCollisionAtTime = FutureTimeSteps + ShotLifetime;
	int BestDeltaDir = 0;
	int BestTime = -1;
	bool DoShoot = false;

	int CurrentObjectsStates = 0;
	int FreeRotationTime = 0;
	for(int t = 0; t < FutureTimeSteps; t++)
	{
		if(t)
		{
			if(NumPlayers &&
				Objects[PlayerIndex].Status >= 0 &&
				InvisibleTimer == 0)
				FreeRotationTime++;
			Move(KeysPacket(), ShotInfo());
			while(t-1 == ObjectsStates[CurrentObjectsStates].ValidUntilTime)
				CurrentObjectsStates++;
		}

		if(FireHyperspaceToggle & 0x80 || InvisibleTimer)
			continue;
		int NewShot = PlayerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == PlayerShotMinIndex)
				break;
		if(NewShot == PlayerShotMinIndex-1)
			continue;
		int CollisionAtTime = Min(ShotLifetime-4 + (3-(FastTimer&3)) + t, MinCollisionAtTime);

		for(int DeltaDir = -FreeRotationTime*RotationSpeed; DeltaDir <= FreeRotationTime*RotationSpeed; DeltaDir += RotationSpeed)
		{
			//Hier simulieren wir einen Schuss in t Frames bei einer Schiffsdrehung von DeltaDir
			word StartX = Objects[PlayerIndex].PositionX;
			word StartY = Objects[PlayerIndex].PositionY;
			char VelocityX = Objects[PlayerIndex].VelocityX;
			char VelocityY = Objects[PlayerIndex].VelocityY;
			ShootLocationFromAngle(ShipDirection+DeltaDir,
								   StartX,
								   StartY,
								   VelocityX,
								   VelocityY);

			int CurrentObjectsStates2 = CurrentObjectsStates;
			for(int t2 = t; t2 < CollisionAtTime; t2++)
			{
				//Wir simulieren die Bewegung des Schusses
				while(t2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime &&
					  NewShot < ObjectsStates[CurrentObjectsStates2].CollisionCauser)
					CurrentObjectsStates2++;

				Object* Objects2 = ObjectsStates[CurrentObjectsStates2].Objects;

				for(int Object = SaucerIndex-2; Object >= 0; Object--)
				{
					//Trifft der Schuss ein Objekt?
					if(Objects2[Object].Status <= 0)
						continue;
					/*word PosX1 = MoveLinearX(Objects[Object].PositionX, Objects[Object].VelocityX, t2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
					word PosX2 = MoveLinearX(ObjectsStates[0].Objects[Object].PositionX, ObjectsStates[0].Objects[Object].VelocityX, t2+1);
					if(PosX1 != PosX2 && ObjectsStates[0].Objects[Object].Status > 0)
					{
						printf("Pos unterschiedlich: %i!=%i\n", PosX1, PosX2);
					}*/
					bool collision = AreObjectsNear(NewShot,
													MoveLinearX(StartX, VelocityX, t2-t+1),
													MoveLinearY(StartY, VelocityY, t2-t+1),
													ShotLifetime/4,//wird ignoriert
						                            Object,
													MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, t2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
													MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, t2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
													Objects2[Object].Status);
					if(!collision)
						continue;

					int CurrentObjectsStates3 = CurrentObjectsStates2;
					while(t2 == ObjectsStates[CurrentObjectsStates3++].ValidUntilTime)
						if(ObjectsStates[CurrentObjectsStates3].DestroyedObject == Object)
						{////////////////
							printf("Vermeide Schuss mit Slot %i auf %x\n", NewShot-PlayerShotMinIndex, Object);
							break;
						}
					if(t2 == ObjectsStates[CurrentObjectsStates3-1].ValidUntilTime)
					{
						t2 = CollisionAtTime;
						break;
					}

					if(DoShoot)
					{
						printf("Doch nicht;)\n");
						DoShoot = false;
					}
					CollisionAtTime = t2;
					MinCollisionAtTime = t2;
					BestDeltaDir = DeltaDir;
					BestTime = t;

					int Index = CalcSecondShoot ? 0 : 1;
					BestDirInfo[Index].CollisionAtTime = t2;
					BestDirInfo[Index].ShotTime = t2-t;
					BestDirInfo[Index].StartX = StartX;
					BestDirInfo[Index].StartY = StartY;
					BestDirInfo[Index].VelocityX = VelocityX;
					BestDirInfo[Index].VelocityY = VelocityY;
				
					pShotInfo->StartTime = byte(FastTimer+1);
					pShotInfo->CollisionTime = byte(FastTimer+t2-t+1);
					pShotInfo->Index = NewShot;
					pShotInfo->PositionX = MoveLinearX(StartX, VelocityX, t2-t+1);
					pShotInfo->PositionY = MoveLinearY(StartY, VelocityY, t2-t+1);
					pShotInfo->ShootTime = BestTime;
					pShotInfo->Target = Object;
					pShotInfo->StartX = StartX;
					pShotInfo->StartY = StartY;
					pShotInfo->VelocityX = VelocityX;
					pShotInfo->VelocityY = VelocityY;

					if(BestTime == 0)
					{
						printf("%sSchiee mit Slot %i um %x auf %x! Kol. voraus. bei %i %i  t=%x\n",
							CalcSecondShoot ? "" : "Sec ",
							NewShot-PlayerShotMinIndex,
							byte(FastTimer+1),
							Object,
							pShotInfo->PositionX,
							pShotInfo->PositionY,
							byte(FastTimer+t2-t+1));
						DoShoot = true;
					}
					break;
				}
				while(t2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime)
					CurrentObjectsStates2++;
			}
		}
	}
	*this = OriginalRam;

	if(pDeltaDir)
		*pDeltaDir = BestDeltaDir;
	KeysPacket keys;
	if(BestDeltaDir > 0)
		keys.left(true);
	else if(BestDeltaDir < 0)
		keys.right(true);
	else if(BestTime == 0)
	{
		assert(DoShoot && !(FireHyperspaceToggle & 0x80));
		keys.fire(true);
	}
	//if(BestDeltaDir == 0)
	//	keys.thrust(true);

	/*ErrorsOccured = false;
	Move(keys, *pShotInfo);
	for(int t = 1; t < FutureTimeSteps+ShotLifetime; t++)
	{
		Move(KeysPacket(), ShotInfo());
	}
	*this = OriginalRam;
	if(ErrorsOccured)
	{
		printf("Fehler...:(\n");
		while(true)
			;
		MessageBeep(0);
		//exit(0);
		return CalcDirInfos(pShotInfo, pDeltaDir, CalcSecondShoot);
	}*/

	if(BestTime != -1 && CalcSecondShoot)
	{
		for(int t = 0; t < BestTime; t++)
			Move(ShipDirection == byte(OriginalRam.ShipDirection+BestDeltaDir) ? KeysPacket() : keys, ShotInfo());
		assert(ShipDirection == byte(OriginalRam.ShipDirection+BestDeltaDir));
		KeysPacket ShootKeys;
		ShootKeys.fire(true);
		ShotInfo ShotInfo2 = *pShotInfo;
		ShotInfo2.ShootTime = 0;
		Move(ShootKeys, ShotInfo2);

		int SecondDeltaDir;
		CalcDirInfos(&ShotInfo2, &SecondDeltaDir, false);
		*this = OriginalRam;

		if(BestTime == 0)
		{
			if(SecondDeltaDir > 0)
			{
				keys.left(true);
				//printf("Extra Links\n");
			}
			else if(SecondDeltaDir < 0)
			{
				keys.right(true);
				//printf("Extra Rechts\n");
			}
		}
	}

	return keys;
}

 //prft, ob das Objekt CollisionCauser mit irgendwas kollidiert und fhrt
//entsprechende Aktionen aus
void GameRam::CheckCollisions(byte CollisionCauser)//sub_69F0
{
	if(Objects[CollisionCauser].Status <= 0)
		return;
	byte y = SaucerIndex;
	if(CollisionCauser < PlayerShotMinIndex)//CollisionCauser ist kein Schuss vom Spieler
		y--;// kann also nicht mit dem UFO kollidieren
	if(CollisionCauser == PlayerIndex)
		y--;//Spieler kann nicht mit sich selbst kollidieren
	do
	{
		if(Objects[y].Status <= 0)
			continue;
		word ShotX = Objects[CollisionCauser].PositionX;
		word ShotY = Objects[CollisionCauser].PositionY;
		if(AreObjectsNear(CollisionCauser,
						  ShotX,
						  ShotY,
						  Objects[CollisionCauser].Status,
						  y,
						  Objects[y].PositionX,
						  Objects[y].PositionY,
						  Objects[y].Status))
		{
			if(CollisionCauser >= PlayerShotMinIndex)
			{
				if(ShotInfos[CollisionCauser-PlayerShotMinIndex].PositionX != ShotX ||
					ShotInfos[CollisionCauser-PlayerShotMinIndex].PositionY != ShotY ||
					ShotInfos[CollisionCauser-PlayerShotMinIndex].CollisionTime != FastTimer ||
					ShotInfos[CollisionCauser-PlayerShotMinIndex].Target != y)
				{//////////////
					ErrorsOccured = true;
					printf("Kollision bei Shot %i verschieden X: %i!=%i  Y: %i!=%i  t: %x!=%x getroffen:%x\n",
						CollisionCauser-PlayerShotMinIndex,
						ShotInfos[CollisionCauser-PlayerShotMinIndex].PositionX, ShotX,
						ShotInfos[CollisionCauser-PlayerShotMinIndex].PositionX, ShotY,
						ShotInfos[CollisionCauser-PlayerShotMinIndex].CollisionTime, FastTimer,
						y);
					//MessageBeep(0);
				}
				ShotInfos[CollisionCauser-PlayerShotMinIndex] = ShotInfo();
			}
			if(OnCollision(CollisionCauser, y) && pObjectsStates)
			{
				pObjectsStates->back().ValidUntilTime = CurrentTime;
				pObjectsStates->back().CollisionCauser = CollisionCauser;
				pObjectsStates->push_back(ObjectsState(CurrentTime+1, y, *this));
			}
			return;
		}
		else if(CollisionCauser >= PlayerShotMinIndex && ShotInfos[CollisionCauser-PlayerShotMinIndex].Target == y)
		{
			assert(ShotInfos[CollisionCauser-PlayerShotMinIndex].Index == CollisionCauser);
			assert(ShotInfos[CollisionCauser-PlayerShotMinIndex].CollisionTime != FastTimer);
		}
	}while(y--);
	if(CollisionCauser >= PlayerShotMinIndex)
	{
		assert(ShotInfos[CollisionCauser-PlayerShotMinIndex].Index == CollisionCauser);
		assert(ShotInfos[CollisionCauser-PlayerShotMinIndex].CollisionTime != FastTimer);
	}
}

void GameRam::ResetAsteroids()//sub_7168
{
	byte x = PlayerIndex-1;
	byte a = NewLevelStartCountdown;
	if(a) goto loc_71DF;
	if(Objects[SaucerIndex].Status)
		return;
	Objects[SaucerIndex].VelocityX = 0;
	Objects[SaucerIndex].VelocityY = 0;
//        Var(RAM_2FD)++;
//		if(Var(RAM_2FD) >= 0x0B)
//	        Var(RAM_2FD)--;
	a = NumAsteroidsStart;
	a += 2;
	if(a >= 0x0B)
		a = 0x0B;
	NumAsteroids = a;
	NumAsteroidsStart = a;
	byte tmp8 = a;
	byte y = SaucerIndex;
loc_719D:
	Objects[x].Status = ((Rand()&0x18)|0x04);
	sub_7203(x, y);
	a = Rand();
	bool c;
	ShiftRight(a, c);
	a &= 0x1F;
	if(!c) goto loc_71C5;
	if(a >= 0x18)
		a &= 0x17;
	HighByte(Objects[x].PositionY) = a;
	Objects[x].PositionX = 0;
	goto loc_71D0;
loc_71C5:
	HighByte(Objects[x].PositionX) = a;
	Objects[x].PositionY = 0;
loc_71D0:
	x--;
	tmp8--;
	if(tmp8) goto loc_719D;
	SaucerCountdown = 0x7F;
	//Var(RAM_2FC) = 0x30;
loc_71DF:
	a = 0;
loc_71E1:
	Objects[x].Status = a;
	x--;
	if(char(x) >= 0) goto loc_71E1;
	if(pObjectsStates)
	{
		pObjectsStates->back().ValidUntilTime = CurrentTime;
		pObjectsStates->back().CollisionCauser = -1;
		pObjectsStates->push_back(ObjectsState(CurrentTime+1, -1, *this));
	}
}


void Player::Run(void)
{
	FramePacket last_frame;
	byte changed[0x100] = {0};
	FramePacket frame;
	KeysPacket keys_packets[10];
	ShotInfo ShotInfos[10];
//	GameStatus game;
	char prevframe = 0;
	int t = 0;
	char current_ping=0;
	char last_ping=127;
	__int64 Score = 0;

	gameram.StartNewGame();

	for(;;)
	{
		MSG msg;
		while(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if(msg.message==WM_QUIT)
				return;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

		keys_packets[t%10].ping = ++current_ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		if(updating)SendPacket(keys_packets[t%10]);
		++t;         // Zeit
		if(updating)ReceivePacket(frame);

		if(updating)
		{
			if(frame.frameno == prevframe+1)
			{
				int i=0;
				for(; i<10; i++)
					if(keys_packets[i].ping==last_ping/*frame.ping-1*/)
						break;
				if(i==10)
					printf("Fehler\n");
				else
				{
					/////////////////////gameram.Move(keys_packets[i]);
					//printf("Move Key: %x Ping: %x\n", keys_packets[i].keys & 0x1f, keys_packets[i].ping);
					//printf("Frame Hash: %x\n", gameram.Hash());
					//////////////////if(gameram.Check(frame.ram, keys_packets[i], false))
					{
					/*	sockaddr_in server;
						memset(&server, 0, sizeof server);
						server.sin_family = AF_INET;
						server.sin_port = htons(1979);
						server.sin_addr.s_addr = server_ip;
						sendto(sd, "stop", 5, 0, (sockaddr*)&server, sizeof server);
						exit(0);*/
					}
				}
			}
			else
				printf("%i Paket(e) verloren\n", int(frame.frameno - prevframe+char(1)));
			gameram.Check(frame.ram, keys_packets[0], ShotInfo(), true);
			last_ping = frame.ping;
			//if(frame.frameno != prevframe+1)
			//	printf("Frame Hash: %x\n", gameram.Hash());
		}
		else
		{
			pScore = &Score;
			gameram.Move(keys_packets[(t-1)%10], ShotInfos[(t-1)%10]);
			pScore = 0;
			RunningTime++;
			char Buffer[128];
			sprintf_s(Buffer, 128, "Score: %i0  Zeit: %i (%i%%)",
				int(Score), RunningTime/60, RunningTime*100/(60*60*5)/*int(Score*60*60*5/RunningTime)*/);
			SetWindowText(hwnd, Buffer);
			if(60*60*5 == RunningTime)
			{
				printf("Score nach 5 Minuten ohne Saucer mit f=%02i: %i0\n", FutureTimeSteps, Score);
				exit(0);
				gameram.StartNewGame();
				RunningTime = 0;
				Score = 0;
				t = 0;
			}
		}

		if (frame.frameno != ++prevframe /*|| frame.ping != keys.ping*/)
		{
//			printf("Latenz %d. %d Frames verloren.\n", current_ping - frame.ping, frame.frameno - prevframe);
			prevframe = frame.frameno;
		}


		/*BitBlt(hdcMem, 0, yFont*2, xChars*xFont, (yChars-2)*yFont, hdcMem, 0, yFont, SRCCOPY);
		for(int i=0; i<0x100; i++)
		{
			const int Start = 0x200;
			if(t > 20 && frame.ram.GetRawRam()[i+Start] != last_frame.ram.GetRawRam()[i+Start])
				changed[i] = 255;
			SetTextColor(hdcMem, RGB(changed[i],0,0));
			if(changed[i]) changed[i]--;
			char Buffer[3];
			sprintf_s(Buffer, 3, "%2.2x", frame.ram.GetRawRam()[i+Start]);
			TextOut(hdcMem, i*xFont*2, yFont, Buffer, 2);
		}*/
		InvalidateRect(hwnd, 0, false);

		last_frame = frame;


		//if(updating) InterpretScreen(frame, game);

		int Latency = 0;
		GameRam OriginalRam = gameram;
		if(updating)
		{
			Latency = current_ping - frame.ping + 1;
			printf("Latenz: %i\n", Latency);
			for(int i = 0; i < Latency; i++)
				gameram.Move(keys_packets[(t+i-Latency)%10], ShotInfos[(t+i-Latency)%10]);
		}

		keys_packets[t%10] = gameram.CalcDirInfos(&ShotInfos[t%10], 0, true);
		if(Latency)
			gameram = OriginalRam;

		//keys_packets[t%10].clear();
		/*int min_dist = 0x7fffffff;
		int min_dx = 0;
		int min_dy = 0;
		if (game.ship_present)
		{
			for (int i=0; i<game.nasteroids; ++i)
			{   // nchstgelegenen Asteroiden suchen
				int dx = game.asteroids[i].x - game.ship_x;
				while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
				while (dx > 511) dx -= 1024;
				int dy = game.asteroids[i].y - game.ship_y;
				while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
				switch (game.asteroids[i].sf)
				{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
					case 0:  // groer Asteroid
						dist -= 40*40;
						break;
					case 15: // mittlerer Asteroid
						dist -= 20*20;
						break;
					case 14: // kleiner Asteroid
						dist -= 8*8;
						break;
				}
				if (dist < min_dist)
				{
					min_dist = dist;
					min_dx = dx;
					min_dy = dy;
				}
			}
			if (game.saucer_present)
			{
				int dx = game.saucer_x - game.ship_x;
				while (dx < -512) dx += 1024;
				while (dx > 511) dx -= 1024;
				int dy = game.saucer_y - game.ship_y;
				while (dy < -384) dy += 768;
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;
				switch (game.saucer_size)
				{	// Abstand um den ungefhren Radius des UFOs korrigieren
				case 15: // groes UFO
					dist -= 20*12;
					break;
				case 14: // kleines UFO
					dist -= 10*6;
					break;
				}
				if (dist < min_dist)
				{
					min_dist = dist;
					min_dx = dx;
					min_dy = dy;
				}
			}

			// Schiff in Richtung auf das nchstgelegene Objekt drehen
			// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
			// ship_dx/y/0 und min_dx/y/0 berechnet
			if (game.ship_dx * min_dy - game.ship_dy * min_dx > 0)
				keys_packets[t%10].left(true);
			else
				keys_packets[t%10].right(true);

			if (min_dist < 30*30)  // Flucht, wenn Kollision unausweichlich
				keys_packets[t%10].hyperspace(true);

			//if (min_dist > 300*300) // beschleunigen, wenn nichts in der Nhe
			//	keys_packets[t%10].thrust(true);

			if (t % 2 == 0)  // Feuerknopf drcken, so schnell es geht
				keys_packets[t%10].fire(true);
		}*/
	}
}

void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	game.clear();

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				game.saucer_present = true;
				game.saucer_x = vx;
				game.saucer_y = vy;
				game.saucer_size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.ship_x = vx;
					game.ship_y = vy;
					game.ship_dx = v1x - dx;
					game.ship_dy = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}


void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(int(sd)+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(0);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(int(sd)+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(_WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static int	cxClient, cyClient ;
	static int xView=0, yView=0;
	HDC			hdc ;
	PAINTSTRUCT	ps ;
	
	switch (message)
	{
	case WM_CREATE:
	{
		::hwnd = hwnd;
		HDC hdcScreen = GetDC(hwnd);
		hBitmap = CreateCompatibleBitmap(hdcScreen, xChars*xFont, yChars*yFont);
		hdcMem  = CreateCompatibleDC(hdcScreen);
		SelectObject(hdcMem, hBitmap);
		ReleaseDC(hwnd, hdcScreen);

		SelectObject(hdcMem, CreateFont (0, 0, 0, 0, 0, 0, 0, 0, DEFAULT_CHARSET, 0, 0, 0, FIXED_PITCH, NULL));
		Rectangle(hdcMem, -1, -1, xChars*xFont+1, yChars*yFont+1);
		for(int i=0; i<0x100; i++)
		{
			char Buffer[3];
			sprintf_s(Buffer, 3, "%2.2x", i);
			TextOut(hdcMem, i*xFont*2, 0, Buffer, 2);
		}
/*		TEXTMETRIC tm;
		GetTextMetrics(hdcMem, &tm);
		xFont = tm.tmAveCharWidth;
		yFont = tm.tmHeight;*/
		return 0;
	}

	case WM_SIZE:
		cxClient = LOWORD (lParam) ;
		cyClient = HIWORD (lParam) ;
		while(xView+cxClient/xFont>xChars)
			xView--;
		return 0 ;

	case WM_KEYDOWN:
		if(wParam==VK_LEFT)
			xView-=2;
		else if(wParam==VK_RIGHT)
			xView+=2;
		else if(wParam==VK_UP)
			yView--;
		else if(wParam==VK_DOWN)
			yView++;
		else
			return 0;
		if(xView<0) xView=0;
		if(yView<0) yView=0;
		while(xView+cxClient/xFont>xChars) xView--;
		InvalidateRect(hwnd, 0, false);
		return 0;

	case WM_LBUTTONDOWN:
		updating = !updating;
		if(!updating)
		{
			gameram.StartNewGame();
			RunningTime = 0;
		}
		return 0;

	case WM_PAINT:
		hdc = BeginPaint (hwnd, &ps) ;
		//BitBlt(hdc, 0, 0, cxClient, cyClient,
		//       hdcMem, xView*xFont, yView*yFont, SRCCOPY);
		gameram.Render(hdc, cxClient, cyClient);
		EndPaint (hwnd, &ps) ;
		return 0 ;
		
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc (hwnd, message, wParam, lParam) ;
}